//
//  DHDNetworkInterface.h
//  DHDMX
//
//  Created by Douglas Heriot on 30/06/12.
//  Copyright (c) 2012 Douglas Heriot Design. All rights reserved.
//

#import <Foundation/Foundation.h>

@interface DHDNetworkInterface : NSObject
{
@private
	NSString *_name;
	
	unsigned int _flags;
	
	NSMutableArray *_mutableIPv4Configs;
	NSMutableArray *_mutableIPv6Configs;
}

@property (copy, readonly) NSString *name;
@property (copy, readonly) NSString *userDefinedName;

@property (readonly) unsigned int flags; // flags defined in <net/if.h>
@property (readonly) BOOL isUp; // IFF_UP
@property (readonly) BOOL isPointToPoint;
@property (readonly) BOOL isLoopback;
@property (readonly) BOOL isRunning; // IFF_RUNNING, resources are allocated
@property (readonly) BOOL isPromiscuous;
@property (readonly) BOOL isReceivingAllMulticast; // IFF_ALLMULTI
@property (readonly) BOOL isActive; // IFF_OACTIVE, transmission in progress
@property (readonly) BOOL isSimplex; // IFF_SIMPLEX, can't hear own transmission
@property (readonly) BOOL supportsBroadcast; // IFF_BROADCAST
@property (readonly) BOOL supportsMulticast; // IFF_MULTICAST

// TODO: what's the different between IFF_UP, IFF_OACTIVE, and IFF_RUNNING?

@property (readonly, copy) NSArray *IPv4Configs;
@property (readonly, copy) NSArray *IPv6Configs;

@end
